/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.lichtower;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.block.CastleBlock;
import twilightforest.entity.TFEntities;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.TFStructureHelper;
import twilightforest.structures.lichtower.LichTowerPieces;
import twilightforest.structures.lichtower.TowerBeardAttachedComponent;
import twilightforest.structures.lichtower.TowerBeardComponent;
import twilightforest.structures.lichtower.TowerBridgeComponent;
import twilightforest.structures.lichtower.TowerRoofAttachedSlabComponent;
import twilightforest.structures.lichtower.TowerRoofComponent;
import twilightforest.structures.lichtower.TowerRoofFenceComponent;
import twilightforest.structures.lichtower.TowerRoofGableForwardsComponent;
import twilightforest.structures.lichtower.TowerRoofPointyOverhangComponent;
import twilightforest.structures.lichtower.TowerRoofSlabComponent;
import twilightforest.structures.lichtower.TowerRoofSlabForwardsComponent;
import twilightforest.structures.lichtower.TowerRoofStairsComponent;
import twilightforest.structures.lichtower.TowerRoofStairsOverhangComponent;
import twilightforest.util.RotationUtil;

public class TowerWingComponent
extends TFStructureComponentOld {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Method HangingEntity_updateFacingWithBoundingBox = ObfuscationReflectionHelper.findMethod(HangingEntity.class, (String)"func_174859_a", (Class[])new Class[]{Direction.class});
    private static final MethodHandle handle_HangingEntity_updateFacingWithBoundingBox;
    public int size;
    protected int height;
    protected Class<? extends TowerRoofComponent> roofType;
    protected ArrayList<BlockPos> openings = new ArrayList();
    protected int highestOpening;
    protected boolean[] openingTowards = new boolean[]{false, false, true, false};

    public TowerWingComponent(TemplateManager manager, CompoundNBT nbt) {
        this(LichTowerPieces.TFLTWin, nbt);
    }

    public TowerWingComponent(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
        this.size = nbt.func_74762_e("towerSize");
        this.height = nbt.func_74762_e("towerHeight");
        this.readOpeningsFromArray(nbt.func_74759_k("doorInts"));
        this.highestOpening = nbt.func_74762_e("highestOpening");
        this.openingTowards[0] = nbt.func_74767_n("openingTowards0");
        this.openingTowards[1] = nbt.func_74767_n("openingTowards1");
        this.openingTowards[2] = nbt.func_74767_n("openingTowards2");
        this.openingTowards[3] = nbt.func_74767_n("openingTowards3");
    }

    protected TowerWingComponent(IStructurePieceType type, TFFeature feature, int i) {
        super(type, feature, i);
        this.highestOpening = 0;
    }

    protected TowerWingComponent(IStructurePieceType type, TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super(type, feature, i);
        this.size = pSize;
        this.height = pHeight;
        this.func_186164_a(direction);
        this.highestOpening = 0;
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction);
    }

    private int[] getDoorsAsIntArray() {
        IntBuffer ibuffer = IntBuffer.allocate(this.openings.size() * 3);
        for (BlockPos door : this.openings) {
            ibuffer.put(door.func_177958_n());
            ibuffer.put(door.func_177956_o());
            ibuffer.put(door.func_177952_p());
        }
        return ibuffer.array();
    }

    @Override
    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("towerSize", this.size);
        tagCompound.func_74768_a("towerHeight", this.height);
        tagCompound.func_74783_a("doorInts", this.getDoorsAsIntArray());
        tagCompound.func_74768_a("highestOpening", this.highestOpening);
        tagCompound.func_74757_a("openingTowards0", this.openingTowards[0]);
        tagCompound.func_74757_a("openingTowards1", this.openingTowards[1]);
        tagCompound.func_74757_a("openingTowards2", this.openingTowards[2]);
        tagCompound.func_74757_a("openingTowards3", this.openingTowards[3]);
    }

    private void readOpeningsFromArray(int[] intArray) {
        for (int i = 0; i < intArray.length; i += 3) {
            BlockPos door = new BlockPos(intArray[i], intArray[i + 1], intArray[i + 2]);
            this.openings.add(door);
        }
    }

    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        this.makeARoof(parent, list, rand);
        this.makeABeard(parent, list, rand);
        if (this.size > 4) {
            for (Rotation towerRotation : RotationUtil.ROTATIONS) {
                int[] dest;
                if (towerRotation == Rotation.CLOCKWISE_180 || this.makeTowerWing(list, rand, 1, (dest = this.getValidOpening(rand, towerRotation))[0], dest[1], dest[2], this.size - 2, this.height - 4, towerRotation) || this.size <= 8 || this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], this.size - 4, this.height - 6, towerRotation)) continue;
                this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], this.size - 6, this.height - 12, towerRotation);
            }
        }
    }

    public boolean makeTowerWing(List<StructurePiece> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        if (wingHeight < 6) {
            return false;
        }
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        if (rand.nextInt(6) == 0) {
            return this.makeBridge(list, rand, index, x, y, z, wingSize, wingHeight, rotation);
        }
        TowerWingComponent wing = new TowerWingComponent(LichTowerPieces.TFLTWin, this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        StructurePiece intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)wing.field_74887_e);
        if (intersect == null || intersect == this) {
            list.add(wing);
            wing.func_74861_a(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        if (rand.nextInt(3) > 0) {
            return this.makeBridge(list, rand, index, x, y, z, wingSize, wingHeight, rotation);
        }
        return false;
    }

    protected boolean makeBridge(List<StructurePiece> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 3, direction);
        if (wingSize == 3 && wingHeight > 10) {
            wingHeight = 6 + rand.nextInt(5);
        }
        TowerBridgeComponent bridge = new TowerBridgeComponent(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        StructurePiece intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)bridge.field_74887_e);
        if (intersect != null && intersect != this) {
            return false;
        }
        intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)bridge.getWingBB());
        if (intersect == null || intersect == this) {
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    public void addOpening(int dx, int dy, int dz, Rotation direction) {
        this.openingTowards[direction.ordinal()] = true;
        if (dy > this.highestOpening) {
            this.highestOpening = dy;
        }
        this.openings.add(new BlockPos(dx, dy, dz));
    }

    public void addOpening(int dx, int dy, int dz, Direction facing) {
        this.addOpening(dx, dy, dz, RotationUtil.getRelativeRotation(this.func_186165_e(), facing));
    }

    public void makeABeard(StructurePiece parent, List<StructurePiece> list, Random rand) {
        boolean attached = parent.func_74874_b().field_78895_b < this.field_74887_e.field_78895_b;
        int index = this.func_74877_c();
        TowerBeardComponent beard = attached ? new TowerBeardAttachedComponent(this.getFeatureType(), index + 1, this) : new TowerBeardComponent(LichTowerPieces.TFLTBea, this.getFeatureType(), index + 1, this);
        list.add(beard);
        beard.func_74861_a(this, list, rand);
    }

    public void makeARoof(StructurePiece parent, List<StructurePiece> list, Random rand) {
        boolean attached;
        boolean bl = attached = parent.func_74874_b().field_78894_e > this.field_74887_e.field_78894_e;
        if (attached) {
            this.makeAttachedRoof(list, rand);
        } else {
            this.makeFreestandingRoof(list, rand);
        }
    }

    protected void makeAttachedRoof(List<StructurePiece> list, Random rand) {
        TowerRoofComponent roof;
        int index = this.func_74877_c();
        if (this.roofType == null && rand.nextInt(32) != 0) {
            this.tryToFitRoof(list, rand, new TowerRoofGableForwardsComponent(this.getFeatureType(), index + 1, this));
        }
        if (this.roofType == null && rand.nextInt(8) != 0) {
            this.tryToFitRoof(list, rand, new TowerRoofSlabForwardsComponent(this.getFeatureType(), index + 1, this));
        }
        if (this.roofType == null && rand.nextInt(32) != 0) {
            roof = new TowerRoofAttachedSlabComponent(this.getFeatureType(), index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new TowerRoofFenceComponent(this.getFeatureType(), index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
    }

    protected void tryToFitRoof(List<StructurePiece> list, Random rand, TowerRoofComponent roof) {
        if (roof.fits(this, list)) {
            list.add(roof);
            roof.func_74861_a(this, list, rand);
            this.roofType = ((Object)((Object)roof)).getClass();
        }
    }

    protected void makeFreestandingRoof(List<StructurePiece> list, Random rand) {
        TowerRoofComponent roof;
        int index = this.func_74877_c();
        if (this.roofType == null && rand.nextInt(8) != 0) {
            roof = new TowerRoofPointyOverhangComponent(this.getFeatureType(), index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new TowerRoofStairsOverhangComponent(this.getFeatureType(), index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new TowerRoofStairsComponent(this.getFeatureType(), index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null && rand.nextInt(53) != 0) {
            roof = new TowerRoofSlabComponent(LichTowerPieces.TFLTRS, this.getFeatureType(), index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new TowerRoofFenceComponent(this.getFeatureType(), index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
    }

    public boolean func_230383_a_(ISeedReader worldIn, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.func_74882_a(worldIn, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, TFStructureComponentOld.getStrongholdStones());
        this.func_74878_a(worldIn, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        if (this.highestOpening > 1) {
            this.makeStairs(worldIn, rand, sbb);
        }
        this.decorateThisTower(worldIn, sbb);
        this.makeWindows(worldIn, sbb, this.size < 4);
        this.makeOpenings(worldIn, sbb);
        return true;
    }

    protected void makeOpeningMarkers(ISeedReader world, Random rand, int numMarkers, MutableBoundingBox sbb) {
        if (this.size > 4) {
            int[] spot;
            int i;
            BlockState woolWhite = Blocks.field_196556_aL.func_176223_P();
            BlockState woolOrange = Blocks.field_196557_aM.func_176223_P();
            BlockState woolMagenta = Blocks.field_196558_aN.func_176223_P();
            BlockState woolLightBlue = Blocks.field_196559_aO.func_176223_P();
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, Rotation.NONE);
                this.func_175811_a(world, woolWhite, spot[0], spot[1], spot[2], sbb);
            }
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, Rotation.CLOCKWISE_90);
                this.func_175811_a(world, woolOrange, spot[0], spot[1], spot[2], sbb);
            }
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, Rotation.CLOCKWISE_180);
                this.func_175811_a(world, woolMagenta, spot[0], spot[1], spot[2], sbb);
            }
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, Rotation.COUNTERCLOCKWISE_90);
                this.func_175811_a(world, woolLightBlue, spot[0], spot[1], spot[2], sbb);
            }
        }
    }

    protected void decorateThisTower(ISeedReader world, MutableBoundingBox sbb) {
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781 * (this.field_74887_e.field_78896_c * 756839)));
        if (this.size > 3) {
            if (this.isDeadEnd()) {
                this.decorateDeadEnd(world, decoRNG, sbb);
            } else {
                this.decorateStairTower(world, decoRNG, sbb);
            }
        }
    }

    protected void decorateDeadEnd(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        BlockState birchPlanks = Blocks.field_196666_p.func_176223_P();
        int floors = (this.height - 1) / 5;
        int floorHeight = this.height / floors;
        for (int i = 1; i < floors; ++i) {
            for (int x = 1; x < this.size - 1; ++x) {
                for (int z = 1; z < this.size - 1; ++z) {
                    this.func_175811_a(world, birchPlanks, x, i * floorHeight, z, sbb);
                }
            }
        }
        if (floors > 1) {
            Rotation ladderDir = Rotation.COUNTERCLOCKWISE_90;
            this.decorateFloor(world, rand, 0, 1, floorHeight, ladderDir, null, sbb);
            for (int i = 1; i < floors - 1; ++i) {
                int bottom = 1 + floorHeight * i;
                int top = floorHeight * (i + 1);
                Rotation downLadderDir = ladderDir;
                ladderDir = ladderDir.func_185830_a(Rotation.CLOCKWISE_90);
                this.decorateFloor(world, rand, i, bottom, top, ladderDir, downLadderDir, sbb);
            }
            this.decorateFloor(world, rand, floors, 1 + floorHeight * (floors - 1), this.height - 1, null, ladderDir, sbb);
        } else {
            this.decorateFloor(world, rand, 0, 1, this.height - 1, null, null, sbb);
        }
    }

    protected void decorateFloor(ISeedReader world, Random rand, int floor, int bottom, int top, @Nullable Rotation ladderUpDir, @Nullable Rotation ladderDownDir, MutableBoundingBox sbb) {
        int dy;
        int dz;
        int dx;
        BlockState ladder = Blocks.field_150468_ap.func_176223_P();
        if (ladderUpDir != null) {
            BlockState ladderUp = (BlockState)ladder.func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)ladderUpDir.func_185831_a(Direction.EAST));
            dx = this.getLadderX(ladderUpDir);
            dz = this.getLadderZ(ladderUpDir);
            for (dy = bottom; dy < top; ++dy) {
                this.func_175811_a(world, ladderUp, dx, dy, dz, sbb);
            }
        }
        if (ladderDownDir != null) {
            BlockState ladderDown = (BlockState)ladder.func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)ladderDownDir.func_185831_a(Direction.EAST));
            dx = this.getLadderX(ladderDownDir);
            dz = this.getLadderZ(ladderDownDir);
            for (dy = bottom - 1; dy < bottom + 2; ++dy) {
                this.func_175811_a(world, ladderDown, dx, dy, dz, sbb);
            }
        }
        if (rand.nextInt(7) == 0 && ladderDownDir == null) {
            this.decorateWell(world, rand, bottom, sbb);
        } else if (rand.nextInt(7) == 0 && ladderDownDir == null) {
            this.decorateSkeletonRoom(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(6) == 0 && ladderDownDir == null) {
            this.decorateZombieRoom(world, rand, bottom, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(5) == 0 && ladderDownDir == null) {
            this.decorateCactusRoom(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(4) == 0 && ladderDownDir != null) {
            this.decorateTreasureChest(world, bottom, top, sbb);
        } else if (rand.nextInt(5) == 0) {
            this.decorateSpiderWebs(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(12) == 0 && ladderDownDir != null) {
            this.decorateSolidRock(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.nextInt(3) == 0) {
            this.decorateFullLibrary(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else {
            this.decorateLibrary(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        }
    }

    protected void decorateWell(ISeedReader world, Random rand, int bottom, MutableBoundingBox sbb) {
        BlockState waterOrLava;
        int cx = this.size / 2;
        BlockState blockState = waterOrLava = rand.nextInt(4) == 0 ? Blocks.field_150353_l.func_176223_P() : Blocks.field_150355_j.func_176223_P();
        if (this.size > 5) {
            BlockState stoneBricks = Blocks.field_196696_di.func_176223_P();
            BlockState stoneSlabs = TFStructureHelper.stoneSlab;
            this.func_175811_a(world, stoneBricks, cx - 1, bottom, cx - 1, sbb);
            this.func_175811_a(world, stoneSlabs, cx - 1, bottom + 1, cx - 1, sbb);
            this.func_175811_a(world, stoneBricks, cx, bottom, cx - 1, sbb);
            this.func_175811_a(world, stoneBricks, cx + 1, bottom, cx - 1, sbb);
            this.func_175811_a(world, stoneSlabs, cx + 1, bottom + 1, cx - 1, sbb);
            this.func_175811_a(world, stoneBricks, cx - 1, bottom, cx, sbb);
            this.func_175811_a(world, waterOrLava, cx, bottom, cx, sbb);
            this.func_175811_a(world, stoneBricks, cx + 1, bottom, cx, sbb);
            this.func_175811_a(world, stoneBricks, cx - 1, bottom, cx + 1, sbb);
            this.func_175811_a(world, stoneSlabs, cx - 1, bottom + 1, cx + 1, sbb);
            this.func_175811_a(world, stoneBricks, cx, bottom, cx + 1, sbb);
            this.func_175811_a(world, stoneBricks, cx + 1, bottom, cx + 1, sbb);
            this.func_175811_a(world, stoneSlabs, cx + 1, bottom + 1, cx + 1, sbb);
        }
        this.func_175811_a(world, waterOrLava, cx, bottom - 1, cx, sbb);
    }

    protected void decorateSkeletonRoom(ISeedReader world, Random rand, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, MutableBoundingBox sbb) {
        this.setSpawner(world, this.size / 2, bottom + 2, this.size / 2, sbb, EntityType.field_200741_ag);
        ArrayList<BlockPos> chainList = new ArrayList<BlockPos>();
        chainList.add(new BlockPos(this.size / 2, bottom + 2, this.size / 2));
        for (int i = 0; i < this.size + 2; ++i) {
            BlockPos chain = new BlockPos(2 + rand.nextInt(this.size - 4), this.height - 2, 2 + rand.nextInt(this.size - 4));
            if (this.chainCollides(chain, chainList)) continue;
            for (int dy = bottom; dy < top; ++dy) {
                this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), chain.func_177958_n(), dy, chain.func_177952_p(), sbb);
            }
            chainList.add(chain);
        }
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                if (dx != 1 && dx != this.size - 2 && dz != 1 && dz != this.size - 2 || this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir)) continue;
                this.func_175811_a(world, Blocks.field_196553_aF.func_176223_P(), dx, top - 1, dz, sbb);
            }
        }
    }

    protected void decorateZombieRoom(ISeedReader world, Random rand, int bottom, Rotation ladderUpDir, Rotation ladderDownDir, MutableBoundingBox sbb) {
        this.setSpawner(world, this.size / 2, bottom + 2, this.size / 2, sbb, EntityType.field_200725_aD);
        BlockState ironBars = Blocks.field_150411_aY.func_176223_P();
        BlockState soulSand = Blocks.field_150425_aM.func_176223_P();
        BlockState brownMushroom = Blocks.field_150338_P.func_176223_P();
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                if (this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.nextInt(5) != 0) continue;
                this.func_175811_a(world, brownMushroom, dx, bottom, dz, sbb);
            }
        }
        ArrayList<BlockPos> slabList = new ArrayList<BlockPos>();
        slabList.add(new BlockPos(this.size / 2, bottom + 2, this.size / 2));
        for (int i = 0; i < this.size - 1; ++i) {
            BlockPos slab = new BlockPos(2 + rand.nextInt(this.size - 4), this.height - 2, 2 + rand.nextInt(this.size - 4));
            if (this.chainCollides(slab, slabList)) continue;
            this.func_175811_a(world, ironBars, slab.func_177958_n(), bottom, slab.func_177952_p(), sbb);
            this.func_175811_a(world, TFStructureHelper.birchSlab, slab.func_177958_n(), bottom + 1, slab.func_177952_p(), sbb);
            this.func_175811_a(world, soulSand, slab.func_177958_n(), bottom + 2, slab.func_177952_p(), sbb);
            slabList.add(slab);
        }
    }

    protected void decorateCactusRoom(ISeedReader world, Random rand, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, MutableBoundingBox sbb) {
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                this.func_175811_a(world, Blocks.field_150354_m.func_176223_P(), dx, bottom - 1, dz, sbb);
                if (this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.nextInt(4) != 0) continue;
                this.func_175811_a(world, Blocks.field_196555_aI.func_176223_P(), dx, bottom, dz, sbb);
            }
        }
        ArrayList<BlockPos> cactusList = new ArrayList<BlockPos>();
        cactusList.add(new BlockPos(this.size / 2, bottom + 2, this.size / 2));
        for (int i = 0; i < this.size + 12; ++i) {
            BlockPos cactus = new BlockPos(2 + rand.nextInt(this.size - 4), this.height - 2, 2 + rand.nextInt(this.size - 4));
            if (this.chainCollides(cactus, cactusList)) continue;
            for (int dy = bottom; dy < top; ++dy) {
                this.func_175811_a(world, Blocks.field_150434_aF.func_176223_P(), cactus.func_177958_n(), dy, cactus.func_177952_p(), sbb);
            }
            cactusList.add(cactus);
        }
    }

    protected void decorateTreasureChest(ISeedReader world, int bottom, int top, MutableBoundingBox sbb) {
        int cx = this.size / 2;
        BlockState stoneBrick = Blocks.field_196696_di.func_176223_P();
        BlockState stoneBrickStairs = Blocks.field_150390_bg.func_176223_P();
        BlockState topStoneBrickStairs = (BlockState)stoneBrickStairs.func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)Half.TOP);
        this.func_175811_a(world, stoneBrick, cx, bottom, cx, sbb);
        this.func_175811_a(world, stoneBrick, cx, top - 1, cx, sbb);
        if (this.size < 6) {
            this.surroundBlockCardinalRotated(world, stoneBrickStairs, cx, bottom, cx, sbb);
            this.surroundBlockCardinalRotated(world, topStoneBrickStairs, cx, top - 1, cx, sbb);
        } else {
            this.surroundBlockCardinalRotated(world, stoneBrickStairs, cx, bottom, cx, sbb);
            this.surroundBlockCorners(world, stoneBrick, cx, bottom, cx, sbb);
            for (int cy = bottom + 1; cy < top - 1; ++cy) {
                this.surroundBlockCorners(world, stoneBrick, cx, cy, cx, sbb);
            }
            this.surroundBlockCardinalRotated(world, topStoneBrickStairs, cx, top - 1, cx, sbb);
            this.surroundBlockCorners(world, stoneBrick, cx, top - 1, cx, sbb);
        }
        this.placeTreasureAtCurrentPosition(world, cx, bottom + 1, cx, TFTreasure.tower_room, sbb);
    }

    protected void decorateSpiderWebs(ISeedReader world, Random rand, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, MutableBoundingBox sbb) {
        for (int dy = bottom; dy < top; ++dy) {
            int chance = top - dy + 2;
            for (int dx = 1; dx <= this.size - 2; ++dx) {
                for (int dz = 1; dz <= this.size - 2; ++dz) {
                    if (this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.nextInt(chance) != 0) continue;
                    this.func_175811_a(world, Blocks.field_196553_aF.func_176223_P(), dx, dy, dz, sbb);
                }
            }
        }
        if (rand.nextInt(5) == 0) {
            EntityType spiderName;
            switch (rand.nextInt(4)) {
                case 3: {
                    spiderName = EntityType.field_200794_h;
                    break;
                }
                case 2: {
                    spiderName = TFEntities.swarm_spider;
                    break;
                }
                case 1: {
                    spiderName = TFEntities.hedge_spider;
                    break;
                }
                default: {
                    spiderName = EntityType.field_200748_an;
                }
            }
            this.setSpawner(world, this.size / 2, bottom + 2, this.size / 2, sbb, spiderName);
        } else {
            this.decorateFurniture(world, rand, bottom, this.size - 2, sbb);
        }
    }

    protected void decorateFurniture(ISeedReader world, Random rand, int bottom, int freeSpace, MutableBoundingBox sbb) {
        if (rand.nextInt(3) > 0) {
            this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), this.size / 2, bottom, this.size / 2, sbb);
            this.func_175811_a(world, Blocks.field_196663_cq.func_176223_P(), this.size / 2, bottom + 1, this.size / 2, sbb);
        }
        BlockState spruceStairs = Blocks.field_150485_bF.func_176223_P();
        if (rand.nextInt(3) == 0 && freeSpace > 1) {
            this.func_175811_a(world, (BlockState)spruceStairs.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.WEST), this.size / 2 + 1, bottom, this.size / 2, sbb);
        }
        if (rand.nextInt(3) == 0 && freeSpace > 1) {
            this.func_175811_a(world, (BlockState)spruceStairs.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.NORTH), this.size / 2, bottom, this.size / 2 + 1, sbb);
        }
        if (rand.nextInt(3) == 0 && freeSpace > 1) {
            this.func_175811_a(world, (BlockState)spruceStairs.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.EAST), this.size / 2 - 1, bottom, this.size / 2, sbb);
        }
        if (rand.nextInt(3) == 0 && freeSpace > 1) {
            this.func_175811_a(world, (BlockState)spruceStairs.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH), this.size / 2, bottom, this.size / 2 - 1, sbb);
        }
    }

    protected void decorateSolidRock(ISeedReader world, Random rand, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, MutableBoundingBox sbb) {
        for (int dy = bottom; dy < top; ++dy) {
            for (int dx = 1; dx <= this.size - 2; ++dx) {
                for (int dz = 1; dz <= this.size - 2; ++dz) {
                    if (this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.nextInt(9) == 0) continue;
                    this.func_175811_a(world, Blocks.field_150348_b.func_176223_P(), dx, dy, dz, sbb);
                }
            }
        }
    }

    protected void decorateLibrary(ISeedReader world, Random rand, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, MutableBoundingBox sbb) {
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                for (int dy = bottom; dy < top - 1; ++dy) {
                    if (dx != 1 && dx != this.size - 2 && dz != 1 && dz != this.size - 2 || this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir)) continue;
                    this.func_175811_a(world, Blocks.field_150342_X.func_176223_P(), dx, dy, dz, sbb);
                }
            }
        }
        if (rand.nextInt(2) == 0 && this.size > 5) {
            this.decorateLibraryTreasure(world, rand, top, ladderUpDir, ladderDownDir, sbb);
        }
        if (rand.nextInt(2) == 0 && this.size > 5) {
            this.decorateFurniture(world, rand, bottom, this.size - 2, sbb);
        }
    }

    protected void decorateLibraryTreasure(ISeedReader world, Random rand, int top, Rotation ladderUpDir, Rotation ladderDownDir, MutableBoundingBox sbb) {
        switch (rand.nextInt(4)) {
            default: {
                if (!this.isLadderPos(2, 1, ladderUpDir, ladderDownDir)) {
                    this.placeTreasureAtCurrentPosition(world, 2, top - 2, 1, TFTreasure.tower_library, sbb);
                    break;
                }
            }
            case 1: {
                if (!this.isLadderPos(this.size - 2, 2, ladderUpDir, ladderDownDir)) {
                    this.placeTreasureAtCurrentPosition(world, this.size - 2, top - 2, 2, TFTreasure.tower_library, sbb);
                    break;
                }
            }
            case 2: {
                if (!this.isLadderPos(this.size - 3, this.size - 2, ladderUpDir, ladderDownDir)) {
                    this.placeTreasureAtCurrentPosition(world, this.size - 3, top - 2, this.size - 2, TFTreasure.tower_library, sbb);
                    break;
                }
            }
            case 3: {
                if (this.isLadderPos(1, this.size - 3, ladderUpDir, ladderDownDir)) break;
                this.placeTreasureAtCurrentPosition(world, 1, top - 2, this.size - 3, TFTreasure.tower_library, sbb);
            }
        }
    }

    protected void decorateFullLibrary(ISeedReader world, Random rand, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, MutableBoundingBox sbb) {
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                for (int dy = bottom; dy < top; ++dy) {
                    if (!(dx % 2 != 0 && (dz >= dx && dz <= this.size - dx - 1 || dz >= this.size - dx - 1 && dz <= dx)) && (dz % 2 == 0 || (dx < dz || dx > this.size - dz - 1) && (dx < this.size - dz - 1 || dx > dz)) || this.isWindowPos(dx, dy, dz) || this.isOpeningPos(dx, dy, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir)) continue;
                    this.func_175811_a(world, Blocks.field_150342_X.func_176223_P(), dx, dy, dz, sbb);
                }
            }
        }
        if (rand.nextInt(2) == 0 && this.size > 5) {
            this.decorateLibraryTreasure(world, rand, top, ladderUpDir, ladderDownDir, sbb);
        }
    }

    protected void decorateTrap(ISeedReader world, int bottom, int top, MutableBoundingBox sbb) {
        for (int dx = 2; dx <= this.size - 3; ++dx) {
            for (int dz = 2; dz <= this.size - 3; ++dz) {
                if (dx != 2 && dx != this.size - 3 && dz != 2 && dz != this.size - 3) continue;
                this.func_175811_a(world, Blocks.field_150335_W.func_176223_P(), dx, -1, dz, sbb);
            }
        }
        for (int dy = bottom - 2; dy < top - 2; ++dy) {
            this.func_175811_a(world, Blocks.field_150335_W.func_176223_P(), 1, dy, 1, sbb);
            this.func_175811_a(world, Blocks.field_150335_W.func_176223_P(), 1, dy, this.size - 2, sbb);
            this.func_175811_a(world, Blocks.field_150335_W.func_176223_P(), this.size - 2, dy, 1, sbb);
            this.func_175811_a(world, Blocks.field_150335_W.func_176223_P(), this.size - 2, dy, this.size - 2, sbb);
        }
    }

    protected boolean isWindowPos(int x, int z) {
        if (x == 1 && z == this.size / 2) {
            return true;
        }
        if (x == this.size - 2 && z == this.size / 2) {
            return true;
        }
        if (x == this.size / 2 && z == 1) {
            return true;
        }
        return x == this.size / 2 && z == this.size - 2;
    }

    protected boolean isWindowPos(int x, int y, int z) {
        int checkYDir = -1;
        if (x == 1 && z == this.size / 2) {
            checkYDir = 2;
        } else if (x == this.size - 2 && z == this.size / 2) {
            checkYDir = 0;
        } else if (x == this.size / 2 && z == 1) {
            checkYDir = 3;
        } else if (x == this.size / 2 && z == this.size - 2) {
            checkYDir = 1;
        }
        if (checkYDir > -1) {
            return !this.openingTowards[checkYDir] && (y == 2 || y == 3 || this.height > 8 && (y == this.height - 3 || y == this.height - 4));
        }
        return false;
    }

    protected boolean isOpeningPos(int x, int y, int z) {
        for (BlockPos door : this.openings) {
            BlockPos.Mutable inside = new BlockPos.Mutable(door.func_177958_n(), door.func_177956_o(), door.func_177952_p());
            if (inside.func_177958_n() == 0) {
                inside.func_189536_c(Direction.EAST);
            } else if (inside.func_177958_n() == this.size - 1) {
                inside.func_189536_c(Direction.WEST);
            } else if (inside.func_177952_p() == 0) {
                inside.func_189536_c(Direction.SOUTH);
            } else if (inside.func_177952_p() == this.size - 1) {
                inside.func_189536_c(Direction.NORTH);
            }
            if (inside.func_177958_n() != x || inside.func_177952_p() != z || inside.func_177956_o() != y && inside.func_177956_o() + 1 != y) continue;
            return true;
        }
        return false;
    }

    protected boolean isLadderPos(int x, int z, Rotation ladderUpDir, Rotation ladderDownDir) {
        if (ladderUpDir != null && x == this.getLadderX(ladderUpDir) && z == this.getLadderZ(ladderUpDir)) {
            return true;
        }
        return ladderDownDir != null && x == this.getLadderX(ladderDownDir) && z == this.getLadderZ(ladderDownDir);
    }

    protected int getLadderX(Rotation ladderDir) {
        switch (ladderDir) {
            case NONE: {
                return this.size - 2;
            }
            case CLOCKWISE_90: {
                return this.size / 2 + 1;
            }
            case CLOCKWISE_180: {
                return 1;
            }
            case COUNTERCLOCKWISE_90: {
                return this.size / 2 - 1;
            }
        }
        return this.size / 2;
    }

    protected int getLadderZ(Rotation ladderDir) {
        switch (ladderDir) {
            case NONE: {
                return this.size / 2 - 1;
            }
            case CLOCKWISE_90: {
                return this.size - 2;
            }
            case CLOCKWISE_180: {
                return this.size / 2 + 1;
            }
            case COUNTERCLOCKWISE_90: {
                return 1;
            }
        }
        return this.size / 2;
    }

    protected void decorateStairTower(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        if (this.height - this.highestOpening > 8) {
            int base = this.highestOpening + 3;
            int floors = (this.height - base) / 5;
            int floorHeight = (this.height - base) / floors;
            for (int i = 0; i < floors; ++i) {
                for (int x = 1; x < this.size - 1; ++x) {
                    for (int z = 1; z < this.size - 1; ++z) {
                        this.func_175811_a(world, TFStructureHelper.birchPlanks, x, i * floorHeight + base, z, sbb);
                    }
                }
            }
            Rotation ladderDir = Rotation.NONE;
            int dx = this.getLadderX(ladderDir);
            int dz = this.getLadderZ(ladderDir);
            BlockState defaultState = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)ladderDir.func_185831_a(Direction.EAST));
            for (int dy = 1; dy < 3; ++dy) {
                this.func_175811_a(world, defaultState, dx, base - dy, dz, sbb);
            }
            for (int i = 0; i < floors - 1; ++i) {
                int bottom = base + 1 + floorHeight * i;
                int top = base + floorHeight * (i + 1);
                Rotation downLadderDir = ladderDir;
                ladderDir = ladderDir.func_185830_a(Rotation.CLOCKWISE_90);
                this.decorateFloor(world, rand, i, bottom, top, ladderDir, downLadderDir, sbb);
            }
            this.decorateFloor(world, rand, floors, base + 1 + floorHeight * (floors - 1), this.height - 1, null, ladderDir, sbb);
            if (base > 8) {
                switch (rand.nextInt(4)) {
                    case 0: {
                        this.decorateChandelier(world, rand, base + 1, sbb);
                        break;
                    }
                    case 1: {
                        this.decorateHangingChains(world, rand, base + 1, sbb);
                        break;
                    }
                    case 2: {
                        this.decorateFloatingBooks(world, rand, base + 1, sbb);
                        break;
                    }
                    case 3: {
                        this.decorateFloatingVines(world, rand, base + 1, sbb);
                    }
                }
            }
        } else if (this.size > 5) {
            switch (rand.nextInt(4)) {
                case 0: {
                    this.decorateChandelier(world, rand, this.height, sbb);
                    break;
                }
                case 1: {
                    this.decorateHangingChains(world, rand, this.height, sbb);
                    break;
                }
                case 2: {
                    this.decorateFloatingBooks(world, rand, this.height, sbb);
                    break;
                }
                case 3: {
                    this.decorateFloatingVines(world, rand, this.height, sbb);
                }
            }
        } else if (this.size > 3) {
            switch (rand.nextInt(3)) {
                case 0: {
                    this.decorateHangingChains(world, rand, this.height, sbb);
                    break;
                }
                case 1: {
                    this.decorateFloatingBooks(world, rand, this.height, sbb);
                    break;
                }
                case 2: {
                    this.decorateFloatingVines(world, rand, this.height, sbb);
                }
            }
        }
        this.decorateStairFloor(world, rand, sbb);
    }

    protected void decorateStairFloor(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        if (this.size > 5) {
            if (rand.nextInt(3) == 0) {
                this.decorateStairWell(world, rand, sbb);
            } else if (rand.nextInt(3) > 0 || this.size >= 15) {
                this.decoratePlanter(world, rand, sbb);
            }
        }
    }

    protected void decorateChandelier(ISeedReader world, Random rand, int decoTop, MutableBoundingBox sbb) {
        if (decoTop < 8 || this.size < 8) {
            return;
        }
        int cx = this.size / 2;
        int cy = decoTop - rand.nextInt(decoTop - 7) - 2;
        int cz = this.size / 2;
        BlockState oakFence = Blocks.field_180407_aO.func_176223_P();
        this.surroundBlockCardinal(world, oakFence, cx, cy, cz, sbb);
        this.surroundBlockCardinal(world, oakFence, cx, cy + 1, cz, sbb);
        for (int y = cy; y < decoTop - 1; ++y) {
            this.func_175811_a(world, oakFence, cx, y, cz, sbb);
        }
    }

    protected void decorateHangingChains(ISeedReader world, Random rand, int decoTop, MutableBoundingBox sbb) {
        ArrayList<BlockPos> chainList = new ArrayList<BlockPos>();
        for (int i = 0; i < this.size + 2; ++i) {
            int filled = this.size < 15 ? 2 : 4;
            BlockPos chain = new BlockPos(filled + rand.nextInt(this.size - filled * 2), decoTop - 2, filled + rand.nextInt(this.size - filled * 2));
            if (this.chainCollides(chain, chainList)) continue;
            int length = 1 + rand.nextInt(decoTop - 7);
            this.decorateOneChain(world, rand, chain.func_177958_n(), decoTop, length, chain.func_177952_p(), sbb);
            chainList.add(chain);
        }
    }

    protected boolean chainCollides(BlockPos coords, List<BlockPos> list) {
        for (BlockPos existing : list) {
            if (coords.func_177952_p() == existing.func_177952_p() && Math.abs(coords.func_177958_n() - existing.func_177958_n()) <= 1) {
                return true;
            }
            if (coords.func_177958_n() != existing.func_177958_n() || Math.abs(coords.func_177952_p() - existing.func_177952_p()) > 1) continue;
            return true;
        }
        return false;
    }

    protected void decorateOneChain(ISeedReader world, Random rand, int dx, int decoTop, int length, int dz, MutableBoundingBox sbb) {
        BlockState ballBlock;
        for (int y = 1; y <= length; ++y) {
            this.func_175811_a(world, Blocks.field_150411_aY.func_176223_P(), dx, decoTop - y - 1, dz, sbb);
        }
        switch (rand.nextInt(10)) {
            case 0: {
                ballBlock = Blocks.field_150339_S.func_176223_P();
                break;
            }
            case 1: {
                ballBlock = Blocks.field_150342_X.func_176223_P();
                break;
            }
            case 2: {
                ballBlock = Blocks.field_150424_aL.func_176223_P();
                break;
            }
            case 3: {
                ballBlock = Blocks.field_150425_aM.func_176223_P();
                break;
            }
            case 4: {
                ballBlock = Blocks.field_150359_w.func_176223_P();
                break;
            }
            case 5: {
                ballBlock = Blocks.field_150368_y.func_176223_P();
                break;
            }
            case 6: {
                ballBlock = Blocks.field_196688_de.func_176223_P();
                break;
            }
            default: {
                ballBlock = Blocks.field_150426_aN.func_176223_P();
            }
        }
        this.func_175811_a(world, ballBlock, dx, decoTop - length - 2, dz, sbb);
    }

    protected void decorateFloatingBooks(ISeedReader world, Random rand, int decoTop, MutableBoundingBox sbb) {
        ArrayList<BlockPos> shelfList = new ArrayList<BlockPos>();
        for (int i = 0; i < this.size + 2; ++i) {
            int top;
            int filled = this.size < 15 ? 2 : 4;
            BlockPos shelf = new BlockPos(filled + rand.nextInt(this.size - filled * 2), decoTop - 2, filled + rand.nextInt(this.size - filled * 2));
            if (this.chainCollides(shelf, shelfList)) continue;
            int bottom = 2 + rand.nextInt(decoTop - 7);
            for (int y = top = rand.nextInt(bottom - 1) + 2; y <= bottom; ++y) {
                this.func_175811_a(world, Blocks.field_150342_X.func_176223_P(), shelf.func_177958_n(), decoTop - y, shelf.func_177952_p(), sbb);
            }
            shelfList.add(shelf);
        }
    }

    protected void decorateFloatingVines(ISeedReader world, Random rand, int decoTop, MutableBoundingBox sbb) {
        BlockState mossyCobbleStone = Blocks.field_150341_Y.func_176223_P();
        BlockState vine = Blocks.field_150395_bd.func_176223_P();
        BlockState vineNorth = (BlockState)vine.func_206870_a((Property)VineBlock.field_176273_b, (Comparable)Boolean.valueOf(true));
        BlockState vineSouth = (BlockState)vine.func_206870_a((Property)VineBlock.field_176279_N, (Comparable)Boolean.valueOf(true));
        BlockState vineEast = (BlockState)vine.func_206870_a((Property)VineBlock.field_176278_M, (Comparable)Boolean.valueOf(true));
        BlockState vineWest = (BlockState)vine.func_206870_a((Property)VineBlock.field_176280_O, (Comparable)Boolean.valueOf(true));
        ArrayList<BlockPos> mossList = new ArrayList<BlockPos>();
        for (int i = 0; i < this.size + 2; ++i) {
            int top;
            int filled = this.size < 15 ? 2 : 4;
            BlockPos moss = new BlockPos(filled + rand.nextInt(this.size - filled * 2), decoTop - 2, filled + rand.nextInt(this.size - filled * 2));
            if (this.chainCollides(moss, mossList)) continue;
            int bottom = 2 + rand.nextInt(decoTop - 7);
            for (int y = top = rand.nextInt(bottom - 1) + 2; y <= bottom; ++y) {
                this.func_175811_a(world, mossyCobbleStone, moss.func_177958_n(), decoTop - y, moss.func_177952_p(), sbb);
                this.func_175811_a(world, vineEast, moss.func_177958_n() + 1, decoTop - y, moss.func_177952_p(), sbb);
                this.func_175811_a(world, vineWest, moss.func_177958_n() - 1, decoTop - y, moss.func_177952_p(), sbb);
                this.func_175811_a(world, vineSouth, moss.func_177958_n(), decoTop - y, moss.func_177952_p() + 1, sbb);
                this.func_175811_a(world, vineNorth, moss.func_177958_n(), decoTop - y, moss.func_177952_p() - 1, sbb);
            }
            mossList.add(moss);
        }
        for (int y = this.highestOpening + 3; y < decoTop - 1; ++y) {
            for (int x = 1; x < this.size - 1; ++x) {
                if (rand.nextInt(3) == 0) {
                    this.func_175811_a(world, vineSouth, x, y, 1, sbb);
                }
                if (rand.nextInt(3) != 0) continue;
                this.func_175811_a(world, vineNorth, x, y, this.size - 2, sbb);
            }
            for (int z = 1; z < this.size - 1; ++z) {
                if (rand.nextInt(3) == 0) {
                    this.func_175811_a(world, vineEast, 1, y, z, sbb);
                }
                if (rand.nextInt(3) != 0) continue;
                this.func_175811_a(world, vineWest, this.size - 2, y, z, sbb);
            }
        }
    }

    protected void decoratePlanter(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        int cx;
        int cz = cx = this.size / 2;
        this.surroundBlockCardinal(world, TFStructureHelper.stoneSlab, cx, 1, cz, sbb);
        if (this.size > 7) {
            this.surroundBlockCorners(world, TFStructureHelper.stoneSlabDouble, cx, 1, cz, sbb);
        }
        this.func_175811_a(world, Blocks.field_196658_i.func_176223_P(), cx, 1, cz, sbb);
        int i = rand.nextInt(6);
        boolean isTree = i > 4;
        BlockState plant = isTree ? TFStructureHelper.randomSapling(i) : TFStructureHelper.randomMushroom(i);
        this.func_175811_a(world, plant, cx, 2, cz, sbb);
        BlockPos pos = this.getBlockPosWithOffset(cx, 2, cz);
        BlockState whatHappened = this.func_175807_a((IBlockReader)world, cx, 2, cz, sbb);
        if (whatHappened.func_177230_c() == plant.func_177230_c() || whatHappened.func_177230_c() == Blocks.field_150350_a) {
            this.func_175811_a(world, Blocks.field_150457_bL.func_176223_P(), cx, 2, cz, sbb);
        }
    }

    protected void decorateStairWell(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        int cx;
        int cz = cx = this.size / 2;
        int cy = 1;
        BlockState waterOrLava = rand.nextInt(4) == 0 ? Blocks.field_150353_l.func_176223_P() : Blocks.field_150355_j.func_176223_P();
        BlockState stoneSlab = Blocks.field_222401_hJ.func_176223_P();
        BlockState stoneBrick = Blocks.field_196696_di.func_176223_P();
        if (this.size > 7) {
            this.func_175811_a(world, stoneBrick, cx - 1, cy, cz - 1, sbb);
            this.func_175811_a(world, stoneSlab, cx - 1, cy + 1, cz - 1, sbb);
            this.func_175811_a(world, stoneBrick, cx, cy, cz - 1, sbb);
            this.func_175811_a(world, stoneBrick, cx + 1, cy, cz - 1, sbb);
            this.func_175811_a(world, stoneSlab, cx + 1, cy + 1, cz - 1, sbb);
            this.func_175811_a(world, stoneBrick, cx - 1, cy, cz, sbb);
            this.func_175811_a(world, waterOrLava, cx, cy, cz, sbb);
            this.func_175811_a(world, stoneBrick, cx + 1, cy, cz, sbb);
            this.func_175811_a(world, stoneBrick, cx - 1, cy, cz + 1, sbb);
            this.func_175811_a(world, stoneSlab, cx - 1, cy + 1, cz + 1, sbb);
            this.func_175811_a(world, stoneBrick, cx, cy, cz + 1, sbb);
            this.func_175811_a(world, stoneBrick, cx + 1, cy, cz + 1, sbb);
            this.func_175811_a(world, stoneSlab, cx + 1, cy + 1, cz + 1, sbb);
        }
        this.func_175811_a(world, waterOrLava, cx, cy - 1, cz, sbb);
    }

    public boolean isDeadEnd() {
        return this.openings.size() == 1;
    }

    protected void makeOpenings(ISeedReader world, MutableBoundingBox sbb) {
        for (BlockPos door : this.openings) {
            this.makeDoorOpening(world, door.func_177958_n(), door.func_177956_o(), door.func_177952_p(), sbb);
        }
    }

    protected void makeDoorOpening(ISeedReader world, int dx, int dy, int dz, MutableBoundingBox sbb) {
        this.func_175811_a(world, AIR, dx, dy, dz, sbb);
        this.func_175811_a(world, AIR, dx, dy + 1, dz, sbb);
        if (this.func_175807_a((IBlockReader)world, dx, dy + 2, dz, sbb).func_177230_c() != Blocks.field_150350_a) {
            BlockState state = TFStructureHelper.stoneSlabDouble;
            this.func_175811_a(world, state, dx, dy + 2, dz, sbb);
        }
    }

    public int[] getValidOpening(Random rand, Rotation direction) {
        int wLength = this.size - 2;
        int offset = 1;
        if (this.size == 15) {
            wLength = 11;
            offset = 2;
        }
        if (direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180) {
            int rx = direction == Rotation.NONE ? this.size - 1 : 0;
            int rz = offset + rand.nextInt(wLength);
            int ry = this.getYByStairs(rz, rand, direction);
            return new int[]{rx, ry, rz};
        }
        if (direction == Rotation.CLOCKWISE_90 || direction == Rotation.COUNTERCLOCKWISE_90) {
            int rx = offset + rand.nextInt(wLength);
            int rz = direction == Rotation.CLOCKWISE_90 ? this.size - 1 : 0;
            int ry = this.getYByStairs(rx, rand, direction);
            return new int[]{rx, ry, rz};
        }
        return new int[]{0, 0, 0};
    }

    protected int getYByStairs(int rx, Random rand, Rotation direction) {
        int rise = 1;
        int base = 0;
        if (this.size == 15) {
            rise = 10;
            int n = base = direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180 ? 23 : 28;
        }
        if (this.size == 9) {
            rise = 6;
            int n = base = direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180 ? 2 : 5;
        }
        if (this.size == 7) {
            rise = 4;
            int n = base = direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180 ? 2 : 4;
        }
        if (this.size == 5) {
            rise = 4;
            switch (direction) {
                case NONE: {
                    base = 3;
                    break;
                }
                case CLOCKWISE_90: {
                    base = 2;
                    break;
                }
                case CLOCKWISE_180: {
                    base = 5;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    base = 4;
                }
            }
        }
        int flights = (this.height - 6 - base) / rise + 1;
        if (base > 0 && flights > 0) {
            int flightChosen = rand.nextInt(flights);
            int dy = flightChosen * rise + base;
            dy = this.size == 15 ? (dy -= direction == Rotation.NONE || direction == Rotation.COUNTERCLOCKWISE_90 ? (rx - 2) / 2 : (this.size - rx - 3) / 2) : (dy -= direction == Rotation.NONE || direction == Rotation.COUNTERCLOCKWISE_90 ? (rx - 1) / 2 : (this.size - rx - 2) / 2);
            if (dy < 1) {
                dy = 1;
            }
            return dy;
        }
        return 0;
    }

    protected void makeWindows(ISeedReader world, MutableBoundingBox sbb, boolean real) {
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            boolean realWindows = real && !this.openingTowards[rotation.ordinal()];
            this.makeWindowBlock(world, this.size - 1, 2, this.size / 2, rotation, sbb, realWindows);
            this.makeWindowBlock(world, this.size - 1, 3, this.size / 2, rotation, sbb, realWindows);
            this.makeWindowBase(world, this.size - 1, 1, this.size / 2, rotation, sbb);
            if (this.height <= 8) continue;
            this.makeWindowBlock(world, this.size - 1, this.height - 3, this.size / 2, rotation, sbb, realWindows);
            this.makeWindowBlock(world, this.size - 1, this.height - 4, this.size / 2, rotation, sbb, realWindows);
            this.makeWindowBase(world, this.size - 1, this.height - 5, this.size / 2, rotation, sbb);
        }
    }

    protected void makeWindowBlock(ISeedReader world, int x, int y, int z, Rotation rotation, MutableBoundingBox sbb, boolean realWindows) {
        Direction temp = this.func_186165_e();
        this.func_186164_a(rotation.func_185831_a(temp));
        Block outside = this.func_175807_a((IBlockReader)world, x + 1, y, z, sbb).func_177230_c();
        Block inside = this.func_175807_a((IBlockReader)world, x - 1, y, z, sbb).func_177230_c();
        if (realWindows && inside == Blocks.field_150350_a && outside == Blocks.field_150350_a) {
            this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), x, y, z, sbb);
        } else {
            this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), x, y, z, sbb);
        }
        this.func_186164_a(temp);
    }

    protected void makeWindowBase(ISeedReader world, int x, int y, int z, Rotation rotation, MutableBoundingBox sbb) {
        Direction temp = this.func_186165_e();
        this.func_186164_a(rotation.func_185831_a(temp));
        BlockState state = TFStructureHelper.stoneSlabDouble;
        this.func_175811_a(world, state, x, y, z, sbb);
        this.func_186164_a(temp);
    }

    protected boolean makeStairs(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        if (this.size == 15) {
            return this.makeStairs15(world, rand, sbb);
        }
        if (this.size == 9) {
            return this.makeStairs9(world, rand, sbb);
        }
        if (this.size == 7) {
            return this.makeStairs7(world, rand, sbb);
        }
        if (this.size == 5) {
            return this.makeStairs5(world, rand, sbb);
        }
        return false;
    }

    protected boolean makeStairs5(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        int rise = 1;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs5flight(world, sbb, i * rise, this.getRotation(Rotation.NONE, i * 3), true);
        }
        return true;
    }

    protected void makeStairs5flight(ISeedReader world, MutableBoundingBox sbb, int height, Rotation rotation, boolean useBirchWood) {
        Direction temp = this.func_186165_e();
        this.func_186164_a(rotation.func_185831_a(temp));
        BlockState bottomSlab = useBirchWood ? TFStructureHelper.birchSlab : TFStructureHelper.stoneSlab;
        BlockState topSlab = useBirchWood ? TFStructureHelper.birchSlabTop : TFStructureHelper.stoneSlabTop;
        this.func_175811_a(world, bottomSlab, 2, 1 + height, 3, sbb);
        this.func_175811_a(world, topSlab, 3, 1 + height, 3, sbb);
        this.func_186164_a(temp);
    }

    protected boolean makeStairs7(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        this.func_175811_a(world, TFStructureHelper.birchSlab, 1, 1, 4, sbb);
        this.func_175811_a(world, TFStructureHelper.birchSlabTop, 1, 1, 5, sbb);
        this.func_175811_a(world, TFStructureHelper.stoneSlab, 5, 1, 2, sbb);
        this.func_175811_a(world, TFStructureHelper.stoneSlabTop, 5, 1, 1, sbb);
        int rise = 2;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs7flight(world, sbb, 1 + i * rise, this.getRotation(Rotation.NONE, i * 3), true);
            this.makeStairs7flight(world, sbb, 1 + i * rise, this.getRotation(Rotation.CLOCKWISE_180, i * 3), false);
        }
        return true;
    }

    protected void makeStairs7flight(ISeedReader world, MutableBoundingBox sbb, int height, Rotation rotation, boolean useBirchWood) {
        Direction temp = this.func_186165_e();
        this.func_186164_a(rotation.func_185831_a(temp));
        BlockState slabBottom = useBirchWood ? TFStructureHelper.birchSlab : TFStructureHelper.stoneSlab;
        BlockState slabTop = useBirchWood ? TFStructureHelper.birchSlabTop : TFStructureHelper.stoneSlabTop;
        this.func_175811_a(world, slabBottom, 2, 1 + height, 5, sbb);
        this.func_175811_a(world, slabTop, 3, 1 + height, 5, sbb);
        this.func_175811_a(world, slabBottom, 4, 2 + height, 5, sbb);
        this.func_175811_a(world, slabTop, 5, 2 + height, 5, sbb);
        this.func_186164_a(temp);
    }

    protected boolean makeStairs9(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        this.func_175811_a(world, TFStructureHelper.birchSlab, 1, 1, 6, sbb);
        this.func_175811_a(world, TFStructureHelper.birchSlabTop, 1, 1, 7, sbb);
        this.func_175811_a(world, TFStructureHelper.stoneSlab, 7, 1, 2, sbb);
        this.func_175811_a(world, TFStructureHelper.stoneSlabTop, 7, 1, 1, sbb);
        int rise = 3;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs9flight(world, sbb, 1 + i * rise, this.getRotation(Rotation.NONE, i * 3), true);
            this.makeStairs9flight(world, sbb, 1 + i * rise, this.getRotation(Rotation.CLOCKWISE_180, i * 3), false);
        }
        return true;
    }

    protected void makeStairs9flight(ISeedReader world, MutableBoundingBox sbb, int height, Rotation rotation, boolean useBirchWood) {
        Direction temp = this.func_186165_e();
        this.func_186164_a(rotation.func_185831_a(temp));
        BlockState slabBot = useBirchWood ? TFStructureHelper.birchSlab : TFStructureHelper.stoneSlab;
        BlockState slabTop = useBirchWood ? TFStructureHelper.birchSlabTop : TFStructureHelper.stoneSlabTop;
        this.func_175811_a(world, slabBot, 2, 1 + height, 7, sbb);
        this.func_175811_a(world, slabTop, 3, 1 + height, 7, sbb);
        this.func_175811_a(world, slabBot, 4, 2 + height, 7, sbb);
        this.func_175811_a(world, slabTop, 5, 2 + height, 7, sbb);
        this.func_175811_a(world, slabBot, 6, 3 + height, 7, sbb);
        this.func_175811_a(world, slabTop, 7, 3 + height, 7, sbb);
        this.func_186164_a(temp);
    }

    protected boolean makeStairs15(ISeedReader world, Random rand, MutableBoundingBox sbb) {
        BlockState planks = Blocks.field_196666_p.func_176223_P();
        BlockState oakFence = Blocks.field_180407_aO.func_176223_P();
        BlockState birchSlab = TFStructureHelper.birchSlab;
        BlockState stoneSlab = TFStructureHelper.stoneSlab;
        BlockState doubleStoneSlab = TFStructureHelper.stoneSlabDouble;
        this.func_175811_a(world, birchSlab, 1, 1, 9, sbb);
        this.func_175811_a(world, birchSlab, 2, 1, 9, sbb);
        this.func_175811_a(world, planks, 1, 1, 10, sbb);
        this.func_175811_a(world, planks, 2, 1, 10, sbb);
        this.func_175811_a(world, birchSlab, 1, 2, 11, sbb);
        this.func_175811_a(world, birchSlab, 2, 2, 11, sbb);
        this.func_175811_a(world, planks, 1, 2, 12, sbb);
        this.func_175811_a(world, planks, 2, 2, 12, sbb);
        this.func_175811_a(world, planks, 1, 2, 13, sbb);
        this.func_175811_a(world, planks, 2, 2, 13, sbb);
        this.func_175811_a(world, planks, 3, 2, 11, sbb);
        this.func_175811_a(world, oakFence, 3, 3, 11, sbb);
        this.func_175811_a(world, oakFence, 3, 4, 11, sbb);
        this.func_175811_a(world, planks, 3, 1, 10, sbb);
        this.func_175811_a(world, oakFence, 3, 2, 10, sbb);
        this.func_175811_a(world, oakFence, 3, 3, 10, sbb);
        this.func_175811_a(world, planks, 3, 1, 9, sbb);
        this.func_175811_a(world, oakFence, 3, 2, 9, sbb);
        this.func_175811_a(world, stoneSlab, 13, 1, 5, sbb);
        this.func_175811_a(world, stoneSlab, 12, 1, 5, sbb);
        this.func_175811_a(world, doubleStoneSlab, 13, 1, 4, sbb);
        this.func_175811_a(world, doubleStoneSlab, 12, 1, 4, sbb);
        this.func_175811_a(world, stoneSlab, 13, 2, 3, sbb);
        this.func_175811_a(world, stoneSlab, 12, 2, 3, sbb);
        this.func_175811_a(world, doubleStoneSlab, 13, 2, 2, sbb);
        this.func_175811_a(world, doubleStoneSlab, 12, 2, 2, sbb);
        this.func_175811_a(world, doubleStoneSlab, 13, 2, 1, sbb);
        this.func_175811_a(world, doubleStoneSlab, 12, 2, 1, sbb);
        this.func_175811_a(world, doubleStoneSlab, 11, 2, 3, sbb);
        this.func_175811_a(world, oakFence, 11, 3, 3, sbb);
        this.func_175811_a(world, oakFence, 11, 4, 3, sbb);
        this.func_175811_a(world, doubleStoneSlab, 11, 1, 4, sbb);
        this.func_175811_a(world, oakFence, 11, 2, 4, sbb);
        this.func_175811_a(world, oakFence, 11, 3, 4, sbb);
        this.func_175811_a(world, doubleStoneSlab, 11, 1, 5, sbb);
        this.func_175811_a(world, oakFence, 11, 2, 5, sbb);
        int rise = 5;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs15flight(world, rand, sbb, 2 + i * rise, this.getRotation(Rotation.NONE, i * 3), true);
            this.makeStairs15flight(world, rand, sbb, 2 + i * rise, this.getRotation(Rotation.CLOCKWISE_180, i * 3), false);
        }
        return true;
    }

    private Rotation getRotation(Rotation startRotation, int rotations) {
        int totalIncrements = startRotation.ordinal() + rotations;
        return RotationUtil.ROTATIONS[totalIncrements & 3];
    }

    protected void makeStairs15flight(ISeedReader world, Random rand, MutableBoundingBox sbb, int height, Rotation rotation, boolean useBirchWood) {
        Direction temp = this.func_186165_e();
        this.func_186164_a(rotation.func_185831_a(temp));
        BlockState oakFence = Blocks.field_180407_aO.func_176223_P();
        BlockState slabBot = useBirchWood ? TFStructureHelper.birchSlab : TFStructureHelper.stoneSlab;
        BlockState slabTop = useBirchWood ? TFStructureHelper.birchSlabTop : TFStructureHelper.stoneSlabTop;
        BlockState slabDoub = useBirchWood ? TFStructureHelper.birchPlanks : TFStructureHelper.stoneSlabDouble;
        this.func_175811_a(world, slabBot, 3, 1 + height, 13, sbb);
        this.func_175809_a(world, sbb, rand, 0.9f, 4, 1 + height, 13, slabTop);
        this.func_175811_a(world, slabBot, 5, 2 + height, 13, sbb);
        this.func_175811_a(world, slabTop, 6, 2 + height, 13, sbb);
        this.func_175811_a(world, slabBot, 7, 3 + height, 13, sbb);
        this.func_175811_a(world, slabTop, 8, 3 + height, 13, sbb);
        this.func_175811_a(world, slabBot, 9, 4 + height, 13, sbb);
        this.func_175809_a(world, sbb, rand, 0.9f, 10, 4 + height, 13, slabTop);
        this.func_175809_a(world, sbb, rand, 0.9f, 11, 5 + height, 13, slabBot);
        this.func_175811_a(world, slabTop, 12, 5 + height, 13, sbb);
        this.func_175811_a(world, slabTop, 13, 5 + height, 13, sbb);
        this.func_175809_a(world, sbb, rand, 0.9f, 3, 1 + height, 12, slabBot);
        this.func_175811_a(world, slabTop, 4, 1 + height, 12, sbb);
        this.func_175811_a(world, slabBot, 5, 2 + height, 12, sbb);
        this.func_175811_a(world, slabTop, 6, 2 + height, 12, sbb);
        this.func_175809_a(world, sbb, rand, 0.9f, 7, 3 + height, 12, slabBot);
        this.func_175811_a(world, slabTop, 8, 3 + height, 12, sbb);
        this.func_175811_a(world, slabBot, 9, 4 + height, 12, sbb);
        this.func_175809_a(world, sbb, rand, 0.9f, 10, 4 + height, 12, slabTop);
        this.func_175811_a(world, slabBot, 11, 5 + height, 12, sbb);
        this.func_175811_a(world, slabTop, 12, 5 + height, 12, sbb);
        this.func_175811_a(world, slabTop, 13, 5 + height, 12, sbb);
        this.func_175811_a(world, slabDoub, 4, 1 + height, 11, sbb);
        this.func_175811_a(world, slabDoub, 5, 2 + height, 11, sbb);
        this.func_175809_a(world, sbb, rand, 0.9f, 6, 2 + height, 11, slabTop);
        this.func_175811_a(world, slabDoub, 7, 3 + height, 11, sbb);
        this.func_175809_a(world, sbb, rand, 0.9f, 8, 3 + height, 11, slabTop);
        this.func_175811_a(world, slabDoub, 9, 4 + height, 11, sbb);
        this.func_175811_a(world, slabTop, 10, 4 + height, 11, sbb);
        this.func_175811_a(world, slabDoub, 11, 5 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 4, 2 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 5, 3 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 6, 3 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 7, 4 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 8, 4 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 9, 5 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 10, 5 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 11, 6 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 4, 3 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 6, 4 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 8, 5 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 10, 6 + height, 11, sbb);
        this.func_175811_a(world, oakFence, 11, 7 + height, 11, sbb);
        this.func_186164_a(temp);
    }

    protected void generatePaintingsOnWall(ISeedReader world, Random rand, int howMany, int floorLevel, Direction direction, int minSize, MutableBoundingBox sbb) {
        for (int i = 0; i < howMany; ++i) {
            BlockPos pCoords = this.getRandomWallSpot(rand, floorLevel, direction, sbb);
            PaintingType art = this.getPaintingOfSize(rand, minSize);
            PaintingEntity painting = new PaintingEntity(EntityType.field_200782_V, (World)world.func_201672_e());
            try {
                handle_HangingEntity_updateFacingWithBoundingBox.invoke(painting, direction);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            painting.field_70522_e = art;
            painting.func_70107_b((double)pCoords.func_177958_n(), (double)pCoords.func_177956_o(), (double)pCoords.func_177952_p());
            if (!this.checkPainting(world, painting)) continue;
            world.func_217376_c((Entity)painting);
        }
    }

    protected PaintingType getPaintingOfSize(Random rand, int minSize) {
        ArrayList<PaintingType> valid = new ArrayList<PaintingType>();
        for (PaintingType art : ForgeRegistries.PAINTING_TYPES) {
            if (art.func_200834_b() < minSize && art.func_200832_c() < minSize) continue;
            valid.add(art);
        }
        if (valid.size() > 0) {
            return (PaintingType)valid.get(rand.nextInt(valid.size()));
        }
        return null;
    }

    protected boolean checkPainting(ISeedReader world, PaintingEntity painting) {
        if (painting == null) {
            return false;
        }
        AxisAlignedBB largerBox = painting.func_174813_aQ();
        if (!world.func_226665_a__((Entity)painting, largerBox)) {
            return false;
        }
        List<Entity> collidingEntities = this.getEntitiesInAABB(world, largerBox);
        for (Entity entityOnList : collidingEntities) {
            if (!(entityOnList instanceof HangingEntity)) continue;
            return false;
        }
        return true;
    }

    public List<Entity> getEntitiesInAABB(ISeedReader world, AxisAlignedBB boundingBox) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)((boundingBox.field_72340_a - 2.0) / 16.0));
        int j = MathHelper.func_76128_c((double)((boundingBox.field_72336_d + 2.0) / 16.0));
        int k = MathHelper.func_76128_c((double)((boundingBox.field_72339_c - 2.0) / 16.0));
        int l = MathHelper.func_76128_c((double)((boundingBox.field_72334_f + 2.0) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                IChunk chunk = world.func_217348_a(i1, j1, ChunkStatus.field_222606_b);
                if (!(chunk instanceof ChunkPrimer)) continue;
                ((ChunkPrimer)chunk).func_201652_l().forEach(nbt -> {
                    Entity entity = EntityType.func_220335_a((CompoundNBT)nbt, (World)world.func_201672_e(), e -> e);
                    if (entity != null && boundingBox.func_72326_a(entity.func_174813_aQ())) {
                        list.add(entity);
                    }
                });
            }
        }
        return list;
    }

    protected BlockPos getRandomWallSpot(Random rand, int floorLevel, Direction direction, MutableBoundingBox sbb) {
        int minX = this.field_74887_e.field_78897_a + 2;
        int maxX = this.field_74887_e.field_78893_d - 2;
        int minY = this.field_74887_e.field_78895_b + floorLevel + 2;
        int maxY = this.field_74887_e.field_78894_e - 2;
        int minZ = this.field_74887_e.field_78896_c + 2;
        int maxZ = this.field_74887_e.field_78892_f - 2;
        if (direction == Direction.SOUTH) {
            minZ = this.field_74887_e.field_78896_c;
            maxZ = this.field_74887_e.field_78896_c;
        } else if (direction == Direction.WEST) {
            maxX = this.field_74887_e.field_78893_d;
            minX = this.field_74887_e.field_78893_d;
        } else if (direction == Direction.NORTH) {
            maxZ = this.field_74887_e.field_78892_f;
            minZ = this.field_74887_e.field_78892_f;
        } else if (direction == Direction.EAST) {
            minX = this.field_74887_e.field_78897_a;
            maxX = this.field_74887_e.field_78897_a;
        }
        for (int i = 0; i < 30; ++i) {
            int cz;
            int cy;
            int cx = minX + (maxX > minX ? rand.nextInt(maxX - minX) : 0);
            BlockPos blockPos = new BlockPos(cx, cy = minY + (maxY > minY ? rand.nextInt(maxY - minY) : 0), cz = minZ + (maxZ > minZ ? rand.nextInt(maxZ - minZ) : 0)).func_177972_a(direction);
            if (!sbb.func_175898_b((Vector3i)blockPos)) continue;
            return blockPos;
        }
        TwilightForestMod.LOGGER.info("ComponentTFTowerWing#getRandomWallSpot - We didn't find a valid random spot on the wall.");
        return null;
    }

    protected void makeGlyphBranches(ISeedReader world, Random rand, BlockState colour, MutableBoundingBox sbb) {
        int dz;
        Rotation rotation = RotationUtil.ROTATIONS[rand.nextInt(4)];
        int startHeight = rand.nextInt((int)((float)this.height * 0.66f));
        int startZ = 3 + rand.nextInt(this.size - 6);
        int dx = this.getXWithOffsetRotated(0, startZ, rotation);
        if (sbb.func_175898_b((Vector3i)new BlockPos(dx, this.field_74887_e.field_78895_b + 1, dz = this.getZWithOffsetRotated(0, startZ, rotation)))) {
            BlockPos pos;
            for (int dy = this.func_74862_a(startHeight); dy > 0 && world.func_180495_p(pos = new BlockPos(dx, dy, dz)).func_177230_c() instanceof CastleBlock; --dy) {
                world.func_180501_a(pos, colour, 2);
            }
        }
        int leftOffset = startZ - (1 + rand.nextInt(3));
        int leftHeight = rand.nextInt(this.height - startHeight);
        if (leftOffset >= 0) {
            for (int z = startZ; z > leftOffset; --z) {
                this.setBlockStateRotated(world, colour, 0, startHeight, z, rotation, sbb);
            }
            for (int y = startHeight; y < startHeight + leftHeight; ++y) {
                this.setBlockStateRotated(world, colour, 0, y, leftOffset, rotation, sbb);
            }
        }
        int rightOffset = startZ + (1 + rand.nextInt(3));
        int rightHeight = rand.nextInt(this.height - startHeight);
        if (rightOffset < this.size - 1) {
            for (int z = startZ; z < rightOffset; ++z) {
                this.setBlockStateRotated(world, colour, 0, startHeight, z, rotation, sbb);
            }
            for (int y = startHeight; y < startHeight + rightHeight; ++y) {
                this.setBlockStateRotated(world, colour, 0, y, rightOffset, rotation, sbb);
            }
        }
    }

    static {
        MethodHandle tmp_handle_HangingEntity_updateFacingWithBoundingBox = null;
        try {
            tmp_handle_HangingEntity_updateFacingWithBoundingBox = LOOKUP.unreflect(HangingEntity_updateFacingWithBoundingBox);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        handle_HangingEntity_updateFacingWithBoundingBox = tmp_handle_HangingEntity_updateFacingWithBoundingBox;
    }
}

